/*
 * Decompiled with CFR 0.152.
 */
package drawing;

import geometry.CartesianCoordinate;
import geometry.LineSegment;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;

public final class Canvas
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int xSize;
    private int ySize;
    private final List<LineSegmentInColor> lines;
    private static final int DEFAULT_X = 800;
    private static final int DEFAULT_Y = 600;
    public static final int DEFAULT_LINE_WIDTH = 3;
    private int lineWidth = 3;
    public static final Color DEFAULT_COLOR = Color.BLACK;

    public Canvas() {
        this(800, 600);
    }

    public Canvas(int n, int n2) {
        this.xSize = n;
        this.ySize = n2;
        this.setupCanvas();
        this.lines = Collections.synchronizedList(new ArrayList());
    }

    private void setupCanvas() {
        this.setSize(this.xSize, this.ySize);
        this.setVisible(true);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setStroke(new BasicStroke(this.lineWidth));
        List<LineSegmentInColor> list = this.lines;
        synchronized (list) {
            for (LineSegmentInColor lineSegmentInColor : this.lines) {
                graphics2D.setColor(lineSegmentInColor.getColor());
                LineSegment lineSegment = lineSegmentInColor.getLine();
                CartesianCoordinate cartesianCoordinate = lineSegment.getStartPoint();
                CartesianCoordinate cartesianCoordinate2 = lineSegment.getEndPoint();
                graphics2D.draw(new Line2D.Double(cartesianCoordinate.getX(), cartesianCoordinate.getY(), cartesianCoordinate2.getX(), cartesianCoordinate2.getY()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLineBetweenPoints(CartesianCoordinate cartesianCoordinate, CartesianCoordinate cartesianCoordinate2) {
        LineSegmentInColor lineSegmentInColor = new LineSegmentInColor(new LineSegment(cartesianCoordinate, cartesianCoordinate2));
        List<LineSegmentInColor> list = this.lines;
        synchronized (list) {
            this.lines.add(lineSegmentInColor);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLineBetweenPoints(CartesianCoordinate cartesianCoordinate, CartesianCoordinate cartesianCoordinate2, Color color) {
        LineSegmentInColor lineSegmentInColor = new LineSegmentInColor(new LineSegment(cartesianCoordinate, cartesianCoordinate2), color);
        List<LineSegmentInColor> list = this.lines;
        synchronized (list) {
            this.lines.add(lineSegmentInColor);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLineSegment(LineSegment lineSegment) {
        LineSegmentInColor lineSegmentInColor = new LineSegmentInColor(lineSegment);
        List<LineSegmentInColor> list = this.lines;
        synchronized (list) {
            this.lines.add(lineSegmentInColor);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLineSegment(LineSegment lineSegment, Color color) {
        LineSegmentInColor lineSegmentInColor = new LineSegmentInColor(lineSegment, color);
        List<LineSegmentInColor> list = this.lines;
        synchronized (list) {
            this.lines.add(lineSegmentInColor);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLineSegments(LineSegment[] lineSegmentArray) {
        for (LineSegment lineSegment : lineSegmentArray) {
            LineSegmentInColor lineSegmentInColor = new LineSegmentInColor(lineSegment);
            List<LineSegmentInColor> list = this.lines;
            synchronized (list) {
                this.lines.add(lineSegmentInColor);
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLineSegments(LineSegment[] lineSegmentArray, Color color) {
        for (LineSegment lineSegment : lineSegmentArray) {
            LineSegmentInColor lineSegmentInColor = new LineSegmentInColor(lineSegment, color);
            List<LineSegmentInColor> list = this.lines;
            synchronized (list) {
                this.lines.add(lineSegmentInColor);
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMostRecentLine() {
        List<LineSegmentInColor> list = this.lines;
        synchronized (list) {
            this.lines.remove(this.lines.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<LineSegmentInColor> list = this.lines;
        synchronized (list) {
            this.lines.clear();
        }
        this.repaint();
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int n) {
        this.lineWidth = n;
    }

    private final class LineSegmentInColor {
        private final LineSegment line;
        private final Color color;

        public LineSegmentInColor(LineSegment lineSegment) {
            this.line = lineSegment;
            this.color = DEFAULT_COLOR;
        }

        public LineSegmentInColor(LineSegment lineSegment, Color color) {
            this.line = lineSegment;
            this.color = color;
        }

        public LineSegment getLine() {
            return this.line;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

