/*
 * Decompiled with CFR 0.152.
 */
package flockingprogram;

import drawing.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.Timer;

public class FlockingGUI {
    private static final int WINDOW_WIDTH = 800;
    private static final int WINDOW_HEIGHT = 600;
    private static final int PANEL_WIDTH = 200;
    private static final int SLIDE_DELAY = 10;
    private static final int SLIDE_STEP = 20;
    private static final int EXPANDED_WINDOW_WIDTH = 1000;
    private static final double RANGE_FACTOR = 0.1;
    private static final double STRENGTH_FACTOR = 0.01;
    private static final int INITIAL_TURTLES = 100;
    private static final int INITIAL_SPEED = 5;
    private static final int INITIAL_COHESION_FACTOR = 15;
    private static final int INITIAL_SEPARATION_FACTOR = 30;
    private static final int INITIAL_ALIGNMENT_FACTOR = 80;
    private static final int INITIAL_COHESION_RANGE = 65;
    private static final int INITIAL_SEPARATION_RANGE = 20;
    private static final int INITIAL_ALIGNMENT_RANGE = 65;
    private static final int INITIAL_OBSTACLE_AVOIDANCE_RANGE = 30;
    private static final int INITIAL_OBSTACLE_AVOIDANCE_FACTOR = 75;
    private JFrame frame;
    private Canvas canvas;
    private JPanel menuPanel;
    private JLayeredPane layeredPane;
    private JButton toggleButton;
    private Timer slideTimer;
    private boolean menuVisible = true;
    private JLabel statusLabel;
    private Map<String, JSlider> sliders = new HashMap<String, JSlider>();
    private Map<String, JLabel> sliderLabels = new HashMap<String, JLabel>();
    private SliderCallback callback;

    public FlockingGUI(SliderCallback sliderCallback) {
        this.callback = sliderCallback;
        this.setupGui();
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void updateStatus(String string) {
        this.statusLabel.setText(string);
    }

    private void setupGui() {
        this.frame = new JFrame("Turtle Program");
        this.frame.setSize(1000, 600);
        this.frame.setDefaultCloseOperation(3);
        this.layeredPane = new JLayeredPane();
        this.layeredPane.setPreferredSize(new Dimension(1000, 600));
        this.frame.setContentPane(this.layeredPane);
        this.canvas = new Canvas();
        this.canvas.setBounds(0, 0, 800, 600);
        this.layeredPane.add((Component)this.canvas, JLayeredPane.DEFAULT_LAYER);
        this.toggleButton = new JButton("Close");
        this.toggleButton.setBounds(725, 5, 70, 30);
        this.toggleButton.addActionListener(actionEvent -> this.toggleMenu());
        this.layeredPane.add((Component)this.toggleButton, JLayeredPane.MODAL_LAYER);
        this.menuPanel = new JPanel();
        this.menuPanel.setLayout(new BoxLayout(this.menuPanel, 1));
        this.menuPanel.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        this.menuPanel.setBackground(new Color(120, 120, 120));
        this.menuPanel.setBounds(800, 0, 200, 600);
        this.menuPanel.setVisible(true);
        this.layeredPane.add((Component)this.menuPanel, JLayeredPane.PALETTE_LAYER);
        this.setupMenu();
        this.statusLabel = new JLabel("Status");
        this.statusLabel.setForeground(Color.BLACK);
        this.statusLabel.setOpaque(true);
        this.statusLabel.setBackground(new Color(255, 255, 255, 120));
        this.statusLabel.setBounds(5, 570, 230, 25);
        this.layeredPane.add((Component)this.statusLabel, JLayeredPane.PALETTE_LAYER);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void toggleMenu() {
        if (this.slideTimer != null && this.slideTimer.isRunning()) {
            return;
        }
        int n = this.menuVisible ? 800 : 1000;
        int n2 = this.menuVisible ? -20 : 20;
        this.menuPanel.setVisible(true);
        this.slideTimer = new Timer(10, null);
        Insets insets = this.frame.getInsets();
        int n3 = insets.left + insets.right;
        int n4 = insets.top + insets.bottom;
        int n5 = n + n3;
        int n6 = 600 + n4;
        this.slideTimer.addActionListener(actionEvent -> {
            boolean bl;
            int n6 = this.frame.getWidth();
            int n7 = n6 + n2;
            boolean bl2 = bl = n2 > 0 && n7 >= n5 || n2 < 0 && n7 <= n5;
            if (bl) {
                this.frame.setSize(n5, n6);
                this.layeredPane.setPreferredSize(new Dimension(n, 600));
                this.canvas.setBounds(0, 0, 800, 600);
                this.menuPanel.setBounds(800, 0, 200, 600);
                this.slideTimer.stop();
                boolean bl3 = this.menuVisible = !this.menuVisible;
                if (!this.menuVisible) {
                    this.menuPanel.setVisible(false);
                }
                this.toggleButton.setText(this.menuVisible ? "Close" : "Menu");
            } else {
                this.frame.setSize(n7, n6);
                this.layeredPane.setPreferredSize(new Dimension(n7 - n3, 600));
                this.canvas.setBounds(0, 0, 800, 600);
                this.menuPanel.setBounds(800, 0, 200, 600);
            }
            this.frame.revalidate();
        });
        this.slideTimer.start();
    }

    private JSlider createSlider(String string, String string2, int n, int n2, int n3, int n4, double d, Consumer<Double> consumer) {
        JSlider jSlider = new JSlider(0, n, n2, n3);
        jSlider.setMajorTickSpacing(n4);
        jSlider.setOpaque(false);
        jSlider.setAlignmentX(0.0f);
        double d2 = (double)n3 * d;
        JLabel jLabel = new JLabel(string + " - " + String.format(string2, d2));
        jLabel.setForeground(Color.WHITE);
        jLabel.setAlignmentX(0.0f);
        jSlider.addChangeListener(changeEvent -> {
            double d2 = (double)jSlider.getValue() * d;
            jLabel.setText(string + " - " + String.format(string2, d2));
            consumer.accept(d2);
        });
        this.sliders.put(string, jSlider);
        this.sliderLabels.put(string, jLabel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setOpaque(false);
        jPanel.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        jPanel.add(jSlider);
        this.menuPanel.add(jPanel);
        return jSlider;
    }

    private void addSeparator(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(new Color(60, 220, 60));
        jLabel.setFont(new Font("Arial", 1, 14));
        jLabel.setAlignmentX(0.0f);
        this.menuPanel.add(jLabel);
        JSeparator jSeparator = new JSeparator(0);
        jSeparator.setForeground(Color.WHITE);
        jSeparator.setMaximumSize(new Dimension(180, 1));
        jSeparator.setAlignmentX(0.0f);
        this.menuPanel.add(jSeparator);
        this.menuPanel.add(Box.createRigidArea(new Dimension(0, 5)));
    }

    private void addSliderSection(String string, List<SliderConfig> list) {
        this.addSeparator(string);
        for (SliderConfig sliderConfig : list) {
            this.createSlider(sliderConfig.label, sliderConfig.decimal, sliderConfig.min, sliderConfig.max, sliderConfig.initial, sliderConfig.majorTick, sliderConfig.scale, sliderConfig.callback);
        }
        this.menuPanel.add(Box.createRigidArea(new Dimension(0, 10)));
    }

    private void resetSliderValuesToDefaults() {
        this.sliders.get("Turtle Count").setValue(100);
        this.sliders.get("Turtle Speed").setValue(5);
        this.sliders.get("Cohesion Range").setValue(65);
        this.sliders.get("Cohesion Strength").setValue(15);
        this.sliders.get("Separation Range").setValue(20);
        this.sliders.get("Separation Strength").setValue(30);
        this.sliders.get("Alignment Range").setValue(65);
        this.sliders.get("Alignment Strength").setValue(80);
        this.sliders.get("Avoidance Range").setValue(30);
        this.sliders.get("Avoidance Strength").setValue(75);
    }

    private void resetBehaviourValuesToZero() {
        this.sliders.get("Cohesion Range").setValue(0);
        this.sliders.get("Cohesion Strength").setValue(0);
        this.sliders.get("Separation Range").setValue(0);
        this.sliders.get("Separation Strength").setValue(0);
        this.sliders.get("Alignment Range").setValue(0);
        this.sliders.get("Alignment Strength").setValue(0);
        this.sliders.get("Avoidance Range").setValue(0);
        this.sliders.get("Avoidance Strength").setValue(0);
    }

    private void setupMenu() {
        this.addSliderSection("General", Arrays.asList(FlockingSlider.general("Turtle Count", 0, 200, 100, 50, d -> this.callback.turtleCountChange(d.intValue())), FlockingSlider.general("Turtle Speed", 0, 10, 5, 1, d -> this.callback.speedChange(d.intValue()))));
        SliderConfig[] sliderConfigArray = new SliderConfig[2];
        sliderConfigArray[0] = FlockingSlider.range("Cohesion Range", 65, this.callback::cohesionRangeChange);
        sliderConfigArray[1] = FlockingSlider.strength("Cohesion Strength", 15, this.callback::cohesionChange);
        this.addSliderSection("Cohesion", Arrays.asList(sliderConfigArray));
        SliderConfig[] sliderConfigArray2 = new SliderConfig[2];
        sliderConfigArray2[0] = FlockingSlider.range("Separation Range", 20, this.callback::separationRangeChange);
        sliderConfigArray2[1] = FlockingSlider.strength("Separation Strength", 30, this.callback::separationChange);
        this.addSliderSection("Separation", Arrays.asList(sliderConfigArray2));
        SliderConfig[] sliderConfigArray3 = new SliderConfig[2];
        sliderConfigArray3[0] = FlockingSlider.range("Alignment Range", 65, this.callback::alignmentRangeChange);
        sliderConfigArray3[1] = FlockingSlider.strength("Alignment Strength", 80, this.callback::alignmentChange);
        this.addSliderSection("Alignment", Arrays.asList(sliderConfigArray3));
        SliderConfig[] sliderConfigArray4 = new SliderConfig[2];
        sliderConfigArray4[0] = FlockingSlider.range("Avoidance Range", 30, this.callback::obstacleAvoidanceRangeChange);
        sliderConfigArray4[1] = FlockingSlider.strength("Avoidance Strength", 75, this.callback::obstacleAvoidanceStrengthChange);
        this.addSliderSection("Obstacle Avoidance", Arrays.asList(sliderConfigArray4));
        this.menuPanel.add(Box.createVerticalGlue());
        JButton jButton = new JButton("Disable All Behaviours");
        jButton.setAlignmentX(0.0f);
        jButton.setMaximumSize(new Dimension(180, 30));
        jButton.addActionListener(actionEvent -> this.resetBehaviourValuesToZero());
        this.menuPanel.add(jButton);
        this.menuPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JButton jButton2 = new JButton("Reset to Defaults");
        jButton2.setAlignmentX(0.0f);
        jButton2.setMaximumSize(new Dimension(180, 30));
        jButton2.addActionListener(actionEvent -> {
            this.callback.resetToDefaults();
            this.resetSliderValuesToDefaults();
        });
        this.menuPanel.add(jButton2);
        this.menuPanel.add(Box.createRigidArea(new Dimension(10, 10)));
    }

    private static class FlockingSlider {
        private FlockingSlider() {
        }

        private static SliderConfig general(String string, int n, int n2, int n3, int n4, Consumer<Double> consumer) {
            return new SliderConfig(string, "%.0f", n, n2, n3, n4, 1.0, consumer);
        }

        private static SliderConfig range(String string, int n, Consumer<Double> consumer) {
            return new SliderConfig(string, "%.1f", 0, 100, n, 10, 0.1, consumer);
        }

        private static SliderConfig strength(String string, int n, Consumer<Double> consumer) {
            return new SliderConfig(string, "%.2f", 0, 100, n, 10, 0.01, consumer);
        }
    }

    private static class SliderConfig {
        String label;
        String decimal;
        int min;
        int max;
        int initial;
        int majorTick;
        double scale;
        Consumer<Double> callback;

        SliderConfig(String string, String string2, int n, int n2, int n3, int n4, double d, Consumer<Double> consumer) {
            this.label = string;
            this.decimal = string2;
            this.min = n;
            this.max = n2;
            this.initial = n3;
            this.majorTick = n4;
            this.scale = d;
            this.callback = consumer;
        }
    }

    public static interface SliderCallback {
        public void turtleCountChange(int var1);

        public void speedChange(int var1);

        public void cohesionChange(double var1);

        public void separationChange(double var1);

        public void alignmentChange(double var1);

        public void cohesionRangeChange(double var1);

        public void separationRangeChange(double var1);

        public void alignmentRangeChange(double var1);

        public void obstacleAvoidanceRangeChange(double var1);

        public void obstacleAvoidanceStrengthChange(double var1);

        public void resetToDefaults();
    }
}

