/*
 * Decompiled with CFR 0.152.
 */
package flockingprogram;

import drawing.Canvas;
import flockingprogram.FlockingGUI;
import geometry.CartesianCoordinate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import shape.Rectangle;
import tools.SpatialGrid;
import tools.SystemProperties;
import tools.Utils;
import turtle.DynamicTurtle;
import turtle.TurtleBehaviour;

public class FlockingProgram
implements FlockingGUI.SliderCallback {
    public static final int GAME_LOOP_DELAY = 20;
    public static final int CELL_SIZE = 20;
    public static final int INITIAL_TURTLES = 100;
    public static final int INITIAL_SPEED = 5;
    public static final double INITIAL_COHESION_FACTOR = 0.15;
    public static final double INITIAL_SEPARATION_FACTOR = 0.3;
    public static final double INITIAL_ALIGNMENT_FACTOR = 0.8;
    public static final double INITIAL_COHESION_RANGE = 6.5;
    public static final double INITIAL_SEPARATION_RANGE = 2.0;
    public static final double INITIAL_ALIGNMENT_RANGE = 6.5;
    public static final double INITIAL_OBSTACLE_AVOIDANCE_RANGE = 3.0;
    public static final double INITIAL_OBSTACLE_AVOIDANCE_FACTOR = 0.75;
    private static final int[][] OBSTACLES = new int[][]{{100, 300, 120, 80}, {350, 200, 80, 150}, {550, 100, 150, 120}};
    private int turtleCount = 100;
    private int currentSpeed = 5;
    private double cohesionFactor = 0.15;
    private double cohesionRange = 6.5;
    private double separationFactor = 0.3;
    private double separationRange = 2.0;
    private double alignmentFactor = 0.8;
    private double alignmentRange = 6.5;
    private double obstacleAvoidanceRange = 3.0;
    private double obstacleAvoidanceFactor = 0.75;
    private boolean running;
    private List<DynamicTurtle> turtles;
    private List<Rectangle> obstacles;
    private SpatialGrid spatialGrid;
    private FlockingGUI gui;
    private long lastFpsCheck = System.currentTimeMillis();
    private int frames = 0;
    private int fpsDisplay;

    public FlockingProgram() {
        this.gui = new FlockingGUI(this);
        this.setupObstacles();
        this.spatialGrid = new SpatialGrid(20);
        DynamicTurtle.setSpatialGrid(this.spatialGrid);
        this.setupTurtles();
    }

    @Override
    public void turtleCountChange(int n) {
        this.turtleCount = n;
        this.adjustTurtleCount();
    }

    @Override
    public void speedChange(int n) {
        this.currentSpeed = n;
        for (DynamicTurtle dynamicTurtle : this.turtles) {
            dynamicTurtle.setSpeed(this.currentSpeed);
        }
    }

    @Override
    public void cohesionRangeChange(double d) {
        this.cohesionRange = d;
        this.updateTurtleBehaviours();
    }

    @Override
    public void cohesionChange(double d) {
        this.cohesionFactor = d;
        this.updateTurtleBehaviours();
    }

    @Override
    public void separationRangeChange(double d) {
        this.separationRange = d;
        this.updateTurtleBehaviours();
    }

    @Override
    public void separationChange(double d) {
        this.separationFactor = d;
        this.updateTurtleBehaviours();
    }

    @Override
    public void alignmentRangeChange(double d) {
        this.alignmentRange = d;
        this.updateTurtleBehaviours();
    }

    @Override
    public void alignmentChange(double d) {
        this.alignmentFactor = d;
        this.updateTurtleBehaviours();
    }

    @Override
    public void obstacleAvoidanceRangeChange(double d) {
        this.obstacleAvoidanceRange = d;
        this.updateTurtleBehaviours();
    }

    @Override
    public void obstacleAvoidanceStrengthChange(double d) {
        this.obstacleAvoidanceFactor = d;
        this.updateTurtleBehaviours();
    }

    @Override
    public void resetToDefaults() {
        this.turtleCount = 100;
        this.currentSpeed = 5;
        this.cohesionFactor = 0.15;
        this.cohesionRange = 6.5;
        this.separationFactor = 0.3;
        this.separationRange = 2.0;
        this.alignmentFactor = 0.8;
        this.alignmentRange = 6.5;
        this.obstacleAvoidanceRange = 3.0;
        this.obstacleAvoidanceFactor = 0.75;
        this.adjustTurtleCount();
        this.updateTurtleBehaviours();
    }

    private DynamicTurtle createRandomTurtle() {
        Canvas canvas = this.gui.getCanvas();
        int n = (int)(Math.random() * (double)canvas.getWidth());
        int n2 = (int)(Math.random() * (double)canvas.getHeight());
        TurtleBehaviour turtleBehaviour = new TurtleBehaviour(canvas, n, n2);
        turtleBehaviour.setSpeed(this.currentSpeed);
        turtleBehaviour.setObstacles(this.obstacles);
        turtleBehaviour.setCohesionFactor(this.cohesionFactor);
        turtleBehaviour.setSeparationFactor(this.separationFactor);
        turtleBehaviour.setAlignmentFactor(this.alignmentFactor);
        return turtleBehaviour;
    }

    private void setupTurtles() {
        this.turtles = Collections.synchronizedList(new ArrayList());
        for (int i = 0; i < this.turtleCount; ++i) {
            this.turtles.add(this.createRandomTurtle());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustTurtleCount() {
        List<DynamicTurtle> list = this.turtles;
        synchronized (list) {
            int n = this.turtles.size();
            int n2 = this.turtleCount - n;
            if (n2 > 0) {
                for (int i = 0; i < n2; ++i) {
                    this.turtles.add(this.createRandomTurtle());
                }
            } else if (n2 < 0) {
                for (int i = 0; i < -n2; ++i) {
                    this.turtles.remove(this.turtles.size() - 1).undraw();
                }
            }
            this.gui.getCanvas().repaint();
            TurtleBehaviour.setTotalTurtles(this.turtles.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTurtleBehaviours() {
        List<DynamicTurtle> list = this.turtles;
        synchronized (list) {
            for (DynamicTurtle dynamicTurtle : this.turtles) {
                if (!(dynamicTurtle instanceof TurtleBehaviour)) continue;
                TurtleBehaviour turtleBehaviour = (TurtleBehaviour)dynamicTurtle;
                turtleBehaviour.setCohesionFactor(this.cohesionFactor);
                turtleBehaviour.setSeparationFactor(this.separationFactor);
                turtleBehaviour.setAlignmentFactor(this.alignmentFactor);
                turtleBehaviour.setCohesionRange(this.cohesionRange);
                turtleBehaviour.setSeparationRange(this.separationRange);
                turtleBehaviour.setAlignmentRange(this.alignmentRange);
                turtleBehaviour.setObstacleAvoidanceRange(this.obstacleAvoidanceRange);
                turtleBehaviour.setObstacleAvoidanceFactor(this.obstacleAvoidanceFactor);
            }
        }
    }

    private void setupObstacles() {
        this.obstacles = new ArrayList<Rectangle>();
        Canvas canvas = this.gui.getCanvas();
        for (int[] nArray : OBSTACLES) {
            CartesianCoordinate cartesianCoordinate = new CartesianCoordinate(nArray[0], nArray[1]);
            Rectangle rectangle = new Rectangle(canvas, cartesianCoordinate, nArray[2], nArray[3]);
            rectangle.draw(canvas);
            this.obstacles.add(rectangle);
        }
    }

    private void gameLoop() {
        this.running = true;
        while (this.running) {
            long l = System.currentTimeMillis();
            this.updateTurtles();
            ++this.frames;
            if (l - this.lastFpsCheck >= 1000L) {
                this.fpsDisplay = this.frames;
                this.frames = 0;
                this.lastFpsCheck = l;
            }
            String string = String.format("Canvas: %dx%d | Turtles: %d | FPS: %d", this.gui.getCanvas().getWidth(), this.gui.getCanvas().getHeight(), this.turtles.size(), this.fpsDisplay);
            this.gui.updateStatus(string);
            Utils.pause(20);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTurtles() {
        List<DynamicTurtle> list = this.turtles;
        synchronized (list) {
            this.spatialGrid.clear();
            for (DynamicTurtle dynamicTurtle : this.turtles) {
                this.spatialGrid.insert(dynamicTurtle);
            }
            for (DynamicTurtle dynamicTurtle : this.turtles) {
                dynamicTurtle.undraw();
            }
            for (DynamicTurtle dynamicTurtle : this.turtles) {
                ((TurtleBehaviour)dynamicTurtle).update(20);
                dynamicTurtle.wrapPosition(this.gui.getCanvas().getWidth(), this.gui.getCanvas().getHeight());
            }
            for (DynamicTurtle dynamicTurtle : this.turtles) {
                dynamicTurtle.draw();
            }
        }
    }

    public static void main(String[] stringArray) {
        SystemProperties systemProperties = new SystemProperties();
        systemProperties.printProperties();
        System.out.println("Running Flocking Simulator");
        FlockingProgram flockingProgram = new FlockingProgram();
        flockingProgram.gameLoop();
    }
}

