/*
 * Decompiled with CFR 0.152.
 */
package shape;

import drawing.Canvas;
import geometry.CartesianCoordinate;
import shape.Shape;
import tools.Vector2D;

public class Rectangle
extends Shape {
    private double width;
    private double height;

    public Rectangle(Canvas canvas, CartesianCoordinate cartesianCoordinate) {
        super(canvas, cartesianCoordinate);
    }

    public Rectangle(Canvas canvas, CartesianCoordinate cartesianCoordinate, double d, double d2) {
        super(canvas, cartesianCoordinate);
        this.width = d;
        this.height = d2;
    }

    public double getX() {
        return this.position.getX();
    }

    public double getY() {
        return this.position.getY();
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public boolean contains(double d, double d2) {
        return d >= this.getX() && d <= this.getX() + this.width && d2 >= this.getY() && d2 <= this.getY() + this.height;
    }

    public Vector2D getClosestPoint(double d, double d2) {
        double d3 = Math.max(this.getX(), Math.min(d, this.getX() + this.width));
        double d4 = Math.max(this.getY(), Math.min(d2, this.getY() + this.height));
        return new Vector2D(d3, d4);
    }

    @Override
    public void draw(Canvas canvas) {
        this.turtle.moveTo(this.position.getX(), this.position.getY());
        this.turtle.turn((int)this.angle);
        this.turtle.putPenDown();
        for (int i = 0; i < 4; ++i) {
            this.turtle.move(i % 2 == 0 ? (int)this.width : (int)this.height);
            this.turtle.turn(90);
        }
        this.turtle.putPenUp();
    }
}

