/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import turtle.DynamicTurtle;

public class SpatialGrid {
    private final int cellSize;
    private final Map<GridCell, List<DynamicTurtle>> grid;

    public SpatialGrid(int n) {
        this.cellSize = n;
        this.grid = new HashMap<GridCell, List<DynamicTurtle>>();
    }

    private GridCell getCellForPosition(int n, int n2) {
        int n3 = n / this.cellSize;
        int n4 = n2 / this.cellSize;
        return new GridCell(n3, n4);
    }

    private double calculateDistance(DynamicTurtle dynamicTurtle, DynamicTurtle dynamicTurtle2) {
        int n = dynamicTurtle2.getPositionX() - dynamicTurtle.getPositionX();
        int n2 = dynamicTurtle2.getPositionY() - dynamicTurtle.getPositionY();
        return Math.hypot(n, n2);
    }

    public void clear() {
        this.grid.clear();
    }

    public void insert(DynamicTurtle dynamicTurtle) {
        GridCell gridCell = this.getCellForPosition(dynamicTurtle.getPositionX(), dynamicTurtle.getPositionY());
        if (!this.grid.containsKey(gridCell)) {
            this.grid.put(gridCell, new ArrayList());
        }
        this.grid.get(gridCell).add(dynamicTurtle);
    }

    public List<DynamicTurtle> getNeighbours(DynamicTurtle dynamicTurtle, double d) {
        ArrayList<DynamicTurtle> arrayList = new ArrayList<DynamicTurtle>();
        int n = (int)Math.ceil(d / (double)this.cellSize);
        GridCell gridCell = this.getCellForPosition(dynamicTurtle.getPositionX(), dynamicTurtle.getPositionY());
        for (int i = -n; i <= n; ++i) {
            for (int j = -n; j <= n; ++j) {
                GridCell gridCell2 = new GridCell(gridCell.x + i, gridCell.y + j);
                List<DynamicTurtle> list = this.grid.get(gridCell2);
                if (list == null) continue;
                for (DynamicTurtle dynamicTurtle2 : list) {
                    if (dynamicTurtle2 == dynamicTurtle || !(this.calculateDistance(dynamicTurtle, dynamicTurtle2) <= d)) continue;
                    arrayList.add(dynamicTurtle2);
                }
            }
        }
        return arrayList;
    }

    private static class GridCell {
        final int x;
        final int y;

        GridCell(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            GridCell gridCell = (GridCell)object;
            return this.x == gridCell.x && this.y == gridCell.y;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y);
        }
    }
}

