/*
 * Decompiled with CFR 0.152.
 */
package turtle;

import drawing.Canvas;
import java.util.List;
import shape.Rectangle;
import tools.SpatialGrid;
import tools.Vector2D;
import turtle.Turtle;

public class DynamicTurtle
extends Turtle {
    protected static final int MILLISECONDS_PER_SECOND = 1000;
    private static final double VIEW_ANGLE = 270.0;
    private int speed;
    protected List<Rectangle> obstacles;
    protected static SpatialGrid spatialGrid;

    public DynamicTurtle(Canvas canvas, double d, double d2) {
        super(canvas);
        this.moveTo(d, d2);
        this.draw();
    }

    public static void setSpatialGrid(SpatialGrid spatialGrid) {
        DynamicTurtle.spatialGrid = spatialGrid;
    }

    public void setObstacles(List<Rectangle> list) {
        this.obstacles = list;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int n) {
        this.speed = n;
    }

    public double getExactAngle() {
        return (this.direction % 360 + 360) % 360;
    }

    public void update(int n) {
        double d = n * this.speed;
        this.move((int)d);
    }

    public Vector2D getVectorTo(DynamicTurtle dynamicTurtle) {
        return new Vector2D(dynamicTurtle.getPositionX() - this.getPositionX(), dynamicTurtle.getPositionY() - this.getPositionY());
    }

    private boolean isTurtleInFOV(DynamicTurtle dynamicTurtle) {
        Vector2D vector2D = this.getVectorTo(dynamicTurtle).scale(-1.0);
        double d = Math.toDegrees(Math.atan2(vector2D.getY(), vector2D.getX()));
        double d2 = (d - (double)this.direction + 180.0) % 360.0 - 180.0;
        return Math.abs(d2) <= 270.0;
    }

    private Vector2D calculateFlockingVector(double d, double d2, String string) {
        Vector2D vector2D = new Vector2D(0.0, 0.0);
        double d3 = 0.0;
        List<DynamicTurtle> list = spatialGrid.getNeighbours(this, d);
        for (DynamicTurtle dynamicTurtle : list) {
            Vector2D vector2D2;
            if (dynamicTurtle == this || !this.isTurtleInFOV(dynamicTurtle)) continue;
            Vector2D vector2D3 = this.getVectorTo(dynamicTurtle);
            double d4 = vector2D3.magnitude();
            double d5 = 1.0 - d4 / d;
            if ("separation".equals(string)) {
                vector2D2 = vector2D3.scale(-d5);
            } else if ("cohesion".equals(string)) {
                vector2D2 = vector2D3.scale(d5);
            } else if ("alignment".equals(string)) {
                double d6 = Math.toRadians(dynamicTurtle.direction);
                Vector2D vector2D4 = new Vector2D(Math.cos(d6), Math.sin(d6));
                vector2D2 = vector2D4.scale(d5);
            } else {
                vector2D2 = new Vector2D(0.0, 0.0);
            }
            vector2D = vector2D.add(vector2D2);
            d3 += d5;
        }
        return d3 > 0.0 ? vector2D.scale(d2 / d3) : new Vector2D(0.0, 0.0);
    }

    public Vector2D calculateSeparation(double d, double d2) {
        return this.calculateFlockingVector(d, d2, "separation");
    }

    public Vector2D calculateCohesion(double d, double d2) {
        return this.calculateFlockingVector(d, d2, "cohesion");
    }

    public Vector2D calculateAlignment(double d, double d2) {
        return this.calculateFlockingVector(d, d2, "alignment");
    }

    public Vector2D calculateObstacleAvoidance(double d, double d2) {
        if (this.obstacles == null) {
            return new Vector2D(0.0, 0.0);
        }
        double d3 = 0.0;
        Vector2D vector2D = new Vector2D(0.0, 0.0);
        Vector2D vector2D2 = new Vector2D(this.getPositionX(), this.getPositionY());
        for (Rectangle rectangle : this.obstacles) {
            Vector2D vector2D3 = rectangle.getClosestPoint(vector2D2.getX(), vector2D2.getY());
            Vector2D vector2D4 = vector2D3.subtract(vector2D2);
            double d4 = vector2D4.magnitude();
            if (!(d4 > 0.0) || !(d4 < d)) continue;
            double d5 = 1.0 - d4 / d;
            vector2D = vector2D.add(vector2D4.scale(-d5));
            d3 += d5;
        }
        return d3 > 0.0 ? vector2D.scale(d2 / d3) : new Vector2D(0.0, 0.0);
    }

    private int[] obstacleHitbox(Rectangle rectangle) {
        int n = (int)rectangle.getPosition().getX();
        int n2 = n + (int)rectangle.getWidth();
        int n3 = (int)rectangle.getPosition().getY();
        int n4 = n3 + (int)rectangle.getHeight();
        return new int[]{n, n2, n3, n4};
    }

    protected boolean wouldCollideWithObstacle(int n, int n2) {
        int n3 = n - this.getSize();
        int n4 = n + this.getSize();
        int n5 = n2 - this.getSize();
        int n6 = n2 + this.getSize();
        for (Rectangle rectangle : this.obstacles) {
            int[] nArray = this.obstacleHitbox(rectangle);
            if (n4 <= nArray[0] || n3 >= nArray[1] || n6 <= nArray[2] || n5 >= nArray[3]) continue;
            return true;
        }
        return false;
    }

    protected void bounceOffObstacle() {
        Vector2D vector2D = new Vector2D(this.getPositionX(), this.getPositionY());
        Vector2D vector2D2 = null;
        Rectangle rectangle = null;
        double d = Double.MAX_VALUE;
        for (Rectangle rectangle2 : this.obstacles) {
            Vector2D vector2D3 = rectangle2.getClosestPoint(vector2D.getX(), vector2D.getY());
            double d2 = vector2D3.subtract(vector2D).magnitude();
            if (!(d2 < d)) continue;
            d = d2;
            vector2D2 = vector2D3;
            rectangle = rectangle2;
        }
        if (vector2D2 != null && rectangle != null) {
            double d3 = this.getExactAngle();
            int n = this.getSize();
            int n2 = this.getPositionX();
            int n3 = this.getPositionY();
            int[] nArray = this.obstacleHitbox(rectangle);
            int n4 = n2 + n - nArray[0];
            int n5 = nArray[1] - (n2 - n);
            int n6 = n3 + n - nArray[2];
            int n7 = nArray[3] - (n3 - n);
            int n8 = Math.min(Math.min(n4, n5), Math.min(n6, n7));
            if (n8 == n4) {
                this.moveTo(n2 - n4 - 1, n3);
                d3 = 180.0 - d3;
            } else if (n8 == n5) {
                this.moveTo(n2 + n5 + 1, n3);
                d3 = 180.0 - d3;
            } else if (n8 == n6) {
                this.moveTo(n2, n3 - n6 - 1);
                d3 = 360.0 - d3;
            } else if (n8 == n7) {
                this.moveTo(n2, n3 + n7 + 1);
                d3 = 360.0 - d3;
            }
            this.direction = (int)d3;
        }
    }

    public void wrapPosition(int n, int n2) {
        if (this.getPositionX() < 0) {
            this.moveTo(n, this.getPositionY());
        } else if (this.getPositionX() > n) {
            this.moveTo(0.0, this.getPositionY());
        }
        if (this.getPositionY() < 0) {
            this.moveTo(this.getPositionX(), n2);
        } else if (this.getPositionY() > n2) {
            this.moveTo(this.getPositionX(), 0.0);
        }
    }
}

