/*
 * Decompiled with CFR 0.152.
 */
package turtle;

import drawing.Canvas;
import geometry.CartesianCoordinate;
import java.awt.Color;

public class Turtle {
    protected Canvas canvas;
    private int x;
    private int y;
    private boolean penDown;
    public int direction;
    protected int timesDrawn;
    private int height;
    private Color color;

    public Turtle(Canvas canvas) {
        this.canvas = canvas;
        this.direction = 0;
        this.penDown = false;
        this.timesDrawn = 0;
        this.height = 10;
        this.color = Color.BLACK;
    }

    public void move(int n) {
        int n2 = (int)((double)n * Math.cos(Math.toRadians(this.direction)));
        int n3 = (int)((double)n * Math.sin(Math.toRadians(this.direction)));
        CartesianCoordinate cartesianCoordinate = new CartesianCoordinate(this.x, this.y);
        this.x += n2;
        this.y += n3;
        CartesianCoordinate cartesianCoordinate2 = new CartesianCoordinate(this.x, this.y);
        if (this.penDown) {
            this.canvas.drawLineBetweenPoints(cartesianCoordinate, cartesianCoordinate2, this.color);
            ++this.timesDrawn;
        }
    }

    public void moveTo(double d, double d2) {
        CartesianCoordinate cartesianCoordinate = new CartesianCoordinate(this.x, this.y);
        this.x = (int)d;
        this.y = (int)d2;
        CartesianCoordinate cartesianCoordinate2 = new CartesianCoordinate(this.x, this.y);
        if (this.penDown) {
            this.canvas.drawLineBetweenPoints(cartesianCoordinate, cartesianCoordinate2, this.color);
            ++this.timesDrawn;
        }
    }

    public void turn(int n) {
        this.direction = (this.direction + n) % 360;
    }

    public void putPenUp() {
        this.penDown = false;
    }

    public void putPenDown() {
        this.penDown = true;
    }

    public int getPositionX() {
        return this.x;
    }

    public int getPositionY() {
        return this.y;
    }

    public int getSize() {
        return this.height;
    }

    public void setSize(int n) {
        this.height = n;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void draw() {
        int n = (int)((double)this.height / Math.sin(Math.toRadians(70.0)));
        int n2 = (int)(2.0 * Math.sin(Math.toRadians(20.0)) * (double)this.height / Math.sin(Math.toRadians(70.0)));
        this.move(2 * this.height / 3);
        this.turn(50);
        this.putPenDown();
        for (int i = 0; i < 3; ++i) {
            this.turn(110);
            this.move(i == 1 ? n2 : n);
        }
        this.putPenUp();
        this.turn(-20);
        this.move(-2 * this.height / 3);
    }

    public void undraw() {
        for (int i = 0; i < this.timesDrawn; ++i) {
            this.canvas.removeMostRecentLine();
        }
        this.timesDrawn = 0;
    }
}

