/*
 * Decompiled with CFR 0.152.
 */
package turtle;

import drawing.Canvas;
import java.awt.Color;
import java.util.List;
import tools.Vector2D;
import turtle.DynamicTurtle;

public class TurtleBehaviour
extends DynamicTurtle {
    private static final int MIN_STEPS_BEFORE_ANGULAR_CHANGE = 5;
    private static final int MAX_STEPS_BEFORE_ANGULAR_CHANGE = 25;
    private static final int MIN_ANGULAR_VELOCITY = -180;
    private static final int MAX_ANGULAR_VELOCITY = 180;
    private static int totalTurtles = 100;
    private double obstacleAvoidanceRange = 3.0;
    private double obstacleAvoidanceFactor = 7.5;
    private double separationFactor;
    private double cohesionFactor;
    private double alignmentFactor;
    private double cohesionRange = 5.5;
    private double separationRange = 2.0;
    private double alignmentRange = 5.5;
    private int stepsUntilAngularChange = 0;
    private double angularVelocity;
    private static final float HUE = 0.33f;
    private static final float SATURATION = 1.0f;
    private static final float MIN_BRIGHTNESS = 0.0f;
    private static final float MAX_BRIGHTNESS = 1.0f;

    public TurtleBehaviour(Canvas canvas, double d, double d2) {
        super(canvas, d, d2);
    }

    public void setSeparationFactor(double d) {
        this.separationFactor = d;
    }

    public void setCohesionFactor(double d) {
        this.cohesionFactor = d;
    }

    public void setAlignmentFactor(double d) {
        this.alignmentFactor = d;
    }

    public void setCohesionRange(double d) {
        this.cohesionRange = d;
    }

    public void setSeparationRange(double d) {
        this.separationRange = d;
    }

    public void setAlignmentRange(double d) {
        this.alignmentRange = d;
    }

    public void setObstacleAvoidanceRange(double d) {
        this.obstacleAvoidanceRange = d;
    }

    public void setObstacleAvoidanceFactor(double d) {
        this.obstacleAvoidanceFactor = d;
    }

    private double normaliseAngle(double d) {
        if ((d %= 360.0) > 180.0) {
            d -= 360.0;
        }
        if (d < -180.0) {
            d += 360.0;
        }
        return d;
    }

    private Vector2D calculateSteeringVector() {
        Vector2D vector2D = this.calculateSeparation((double)this.getSize() * this.separationRange, this.separationFactor);
        Vector2D vector2D2 = this.calculateCohesion((double)this.getSize() * this.cohesionRange, this.cohesionFactor);
        Vector2D vector2D3 = this.calculateAlignment((double)this.getSize() * this.alignmentRange, this.alignmentFactor);
        Vector2D vector2D4 = this.calculateObstacleAvoidance((double)this.getSize() * this.obstacleAvoidanceRange, this.obstacleAvoidanceFactor);
        return vector2D.add(vector2D2).add(vector2D3).add(vector2D4);
    }

    private void applySteering(Vector2D vector2D) {
        if (vector2D.getX() == 0.0 && vector2D.getY() == 0.0) {
            return;
        }
        double d = Math.toDegrees(Math.atan2(vector2D.getY(), vector2D.getX()));
        double d2 = this.normaliseAngle(d - (double)this.direction);
        this.turn((int)(d2 / 7.5));
    }

    private Vector2D getNextPosition(int n) {
        double d = Math.toRadians(this.direction);
        int n2 = this.getPositionX() + (int)((double)n * Math.cos(d));
        int n3 = this.getPositionY() + (int)((double)n * Math.sin(d));
        return new Vector2D(n2, n3);
    }

    private void resetAngularVelocityCycle() {
        this.stepsUntilAngularChange = 5 + (int)(Math.random() * 20.0);
        this.angularVelocity = -180.0 + Math.random() * 360.0;
    }

    public static void setTotalTurtles(int n) {
        totalTurtles = n;
    }

    private void updateColourBasedOnFlock() {
        double d = Math.max(Math.max(this.cohesionRange, this.separationRange), this.alignmentRange);
        List<DynamicTurtle> list = spatialGrid.getNeighbours(this, (double)this.getSize() * d);
        int n = 0;
        for (DynamicTurtle dynamicTurtle : list) {
            if (dynamicTurtle == this) continue;
            ++n;
        }
        int n2 = Math.max(1, totalTurtles / 12);
        float f = Math.min((float)n / (float)n2, 1.0f);
        float f2 = 0.0f + f * 1.0f;
        this.setColor(Color.getHSBColor(0.33f, 1.0f, f2));
    }

    @Override
    public void update(int n) {
        int n2;
        Vector2D vector2D;
        Vector2D vector2D2 = this.calculateSteeringVector();
        this.applySteering(vector2D2);
        double d = this.angularVelocity * ((double)n / 1000.0);
        this.turn((int)d);
        if (--this.stepsUntilAngularChange <= 0) {
            this.resetAngularVelocityCycle();
        }
        if (this.wouldCollideWithObstacle((int)(vector2D = this.getNextPosition(n2 = this.getSpeed())).getX(), (int)vector2D.getY())) {
            this.bounceOffObstacle();
        } else {
            this.move(n2);
        }
        this.updateColourBasedOnFlock();
    }
}

